       IDENTIFICATION DIVISION.
      *=======================
       PROGRAM-ID.     PDF-INVOICE.
       AUTHOR.         Eric E. Topada.
       DATE-WRITTEN.   11/22/2019.
      *INSTALLATION.   Microfocus 10.3 Product Launch Webinar.

       ENVIRONMENT DIVISION.
      *====================
       CONFIGURATION SECTION.

       INPUT-OUTPUT SECTION.
      *====================
       FILE-CONTROL.

           SELECT TEXT-FILE
               ASSIGN       TO UX-TEXT-FILE
               ORGANIZATION IS LINE SEQUENTIAL
               ACCESS MODE  IS SEQUENTIAL
               FILE STATUS  IS TEXT-FILE-STATUS.

       DATA DIVISION.
      *=============
       FILE SECTION.

       FD  TEXT-FILE.
       01  TEXT-RECORD            PIC X(255).

       WORKING-STORAGE SECTION.
      *=======================
       01  WORK-FIELD             PIC X(255)          VALUE SPACES.

       01  UX-TEXT-FILE           PIC X(255)          VALUE SPACES.
       01  TEXT-FILE-STATUS       PIC X(2)            VALUE ZEROES.
       01  N-DATE                 PIC 9(8)            VALUE 0.

       01  SYSTEM-DATE            PIC 9(8)            VALUE ZERO.
       01  SYSTEM-DATE-X REDEFINES SYSTEM-DATE
                                  PIC X(8).
       01  SYSTEM-TIME            PIC 9(8)            VALUE ZERO.
       01  REPORT-DATE            PIC ZZ/ZZ/ZZZZ      VALUE ZERO.
       01  REPORT-TIME            PIC ZZ/ZZ/ZZ/ZZ     VALUE ZERO.

       01  IX                     PIC 9(4)            VALUE ZERO.

       01  OS-TYPE                PIC 9(1)            VALUE 0.
           88  OS-IS-UNIX                             VALUE 1.
           88  OS-IS-WINDOWS                          VALUE 0.

       01  THE-OS                 PIC X(7)            VALUE SPACES.
       01  THE-FS                 PIC X(10)           VALUE SPACES.
       01  THE-HOST               PIC X(15)           VALUE SPACES.
       01  DATE9                  PIC 9(8)            VALUE ZERO.

       01  PDF-FILENAME           PIC X(255)          VALUE SPACES.
       01  THE-DESKTOP            PIC X(255)          VALUE SPACES.

       01  PAGE-FONT              HANDLE.
       01  PAGE-TITLE             PIC X(80)           VALUE SPACES.

       01  TEMP-HEIGHT            PIC S9(5)V9(3)  COMP-5.
       01  TEMP-WIDTH             PIC S9(5)V9(3)  COMP-5.
       01  TEMP-COL               pic S9(9)V9(3)  COMP-5.
       01  FONT-SIZE              pic S9(9)V9(3)  COMP-5.

       01  TEXT-LEN               PIC 9(3)            VALUE ZERO.

       01  HPDF-Dest           handle.
       01  HPDF-Image          handle.
       01  ImageWidth          unsigned-int.
       01  ImageHeight         unsigned-int.
       01  Temp-Val-G.
           03 Temp-val-R       PIC S9(9) COMP-5.
           03 Temp-Val REDEFINES Temp-Val-R
                               PIC S9(6)v999 COMP-5.
       78  MY-Page-Width       value 650.
       78  MY-Page-Height      value 500.
       01  full-name.
           03  jpg-name        pic x(80).
       01  page-description    pic x(100).
       01  X                   PIC S9(6)v999 COMP-5.
       01  Y                   PIC S9(6)v999 COMP-5.

       01  WS-LITERAL             PIC X(400)   VALUE SPACES.

       01  INVOICE-RECORD.
           03  INVOICE-KEYWORD    PIC X(30)   VALUE SPACES.
           03  INVOICE-VALUE      PIC X(80)   VALUE SPACES.

       01  COMPANY-RECORD.
           03  COMPANY-NAME       PIC X(50)
               VALUE "Aeroflot Russian Airlines".
           03  COMPANY-STREET     PIC X(50)
               VALUE "1 Arbat St".
           03  COMPANY-CSZ        PIC X(50)
               VALUE "119019, Moscow, Russia".

       01  WS-INVOICE-HEADER.
           03  WS-INVOICE         PIC X(15)   VALUE SPACES.
           03  WS-BILL-COMPANY    PIC X(35)   VALUE SPACES.
           03  WS-BILL-ADDRESS    PIC X(35)   VALUE SPACES.
           03  WS-BILL-CSZ        PIC X(80)   VALUE SPACES.

           03  WS-INVOICE-DATE    PIC 99/99/9999     VALUE ZERO.
           03  WS-DUE-DATE        PIC 99/99/9999     VALUE ZERO.
           03  WS-BALANCE-DUE     PIC $$,$$$,$$9.99- VALUE ZERO.

       01  Z-QUANTITY             PIC ZZZ,ZZ9        VALUE ZERO.
       01  Z-RATE                 PIC $$$,$$9        VALUE ZERO.
       01  Z-AMOUNT               PIC $$$,$$$,$$9    VALUE ZERO.

       01  ITEM-ARRAY.
           03  II-X               PIC 9(4)           VALUE ZERO.
           03  II-TOTAL-AMOUNT    PIC S9(9)V99       VALUE ZERO.
           03  FILLER             OCCURS 99.
             05  II-ITEM          PIC X(80).
             05  II-QUANTITY      PIC 9(4).
             05  II-RATE          PIC 9(5)V99.

           COPY "CPDF.DEF".

       PROCEDURE DIVISION.
      *==================
       DECLARATIVES.

       END DECLARATIVES.
      *================
       START-PROGRAM.

           PERFORM Z000-INITIALIZATION.

           CALL "C$PDF" USING HPDF-NEW GIVING HPDF-DOC.
           IF  HPDF-DOC = NULL
               DISPLAY MESSAGE "UNABLE TO CREATE PDF DOCUMENT"
           ELSE
               PERFORM 100-MAIN-PROCESS
               PERFORM Z900-TERMINATION
           END-IF.

       EXIT-PROGRAM.
      *============
           EXIT PROGRAM.

       STOP-PROGRAM.
      *============
           STOP RUN.

       100-MAIN-PROCESS.
      *================

           PERFORM PAGE-SETUP.
           PERFORM OUTLINE-AND-TITLE.

           CALL "C$PDF" using HPDF-Page-BeginText, HPDF-Page
           compute temp-height = HPDF-PageHeight - 60

           CALL "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, 60, temp-height

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 24.

           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, 390,  -24

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 24.

           MOVE "INVOICE" TO WS-LITERAL.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, WS-LITERAL, temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, WS-LITERAL, text-len.

           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, 0,  -20

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, WS-INVOICE, temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, WS-INVOICE, text-len.


           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, -380, -40.

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, COMPANY-NAME, temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, COMPANY-NAME, text-len.


           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, 0, -14.

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, COMPANY-STREET, temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, COMPANY-STREET, text-len.


           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, 0, -14.

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, COMPANY-CSZ, temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, COMPANY-CSZ, text-len.


           MOVE "Date:" TO WS-LITERAL.
           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, 300, 0.

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, WS-LITERAL, temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, WS-LITERAL, text-len.


           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, 80, 0.

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, WS-INVOICE-DATE, temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, WS-INVOICE-DATE, text-len.


           MOVE "Due Date:" TO WS-LITERAL.
           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, -80, -14.

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, WS-LITERAL, temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, WS-LITERAL, text-len.

           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, 80, 0.

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, WS-DUE-DATE, temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, WS-DUE-DATE, text-len.


           MOVE "Balance:" TO WS-LITERAL.
           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, -80, -14.

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, WS-LITERAL, temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, WS-LITERAL, text-len.

           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, 80, 0.

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, WS-BALANCE-DUE, temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, WS-BALANCE-DUE, text-len.


           MOVE "Bill To:" TO WS-LITERAL.
           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, -380, 0.

           call "C$PDF" using HPDF-Page-SetFontAndSize,

               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, WS-LITERAL, temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, WS-LITERAL, text-len.


           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, 0, -14.

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, WS-BILL-COMPANY, temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, WS-BILL-COMPANY, text-len.

           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, 0, -14.

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, WS-BILL-ADDRESS, temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, WS-BILL-ADDRESS, text-len.


           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, 0, -14.

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, WS-BILL-CSZ, temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, WS-BILL-CSZ, text-len.


           MOVE "ITEM" TO WS-LITERAL.
           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, 0, -56.

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, WS-LITERAL  temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, WS-LITERAL, text-len.



           MOVE "QUANTITY" TO WS-LITERAL.
           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, 220, 0.

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, WS-LITERAL  temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, WS-LITERAL, text-len.



           MOVE "PRICE" TO WS-LITERAL.
           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, 100, 0.

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, WS-LITERAL  temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, WS-LITERAL, text-len.


           MOVE "AMOUNT" TO WS-LITERAL.
           call "C$PDF" using HPDF-Page-MoveTextPos,
               HPDF-Page, 80, 0.

           call "C$PDF" using HPDF-Page-SetFontAndSize,
               HPDF-Page, page-font, 12.

           call "C$PDF" using HPDF-Page-MeasureText,
               HPDF-Page, WS-LITERAL  temp-width,
               HPDF-False giving text-len

           call "C$PDF" using HPDF-Page-ShowText,
               HPDF-Page, WS-LITERAL, text-len.



           PERFORM VARYING IX FROM 1 BY 1 UNTIL IX > II-X
                   call "C$PDF" using HPDF-Page-MoveTextPos
                         HPDF-Page, -400, -14

                   IF  IX = 1
                       MOVE ALL "_" TO WS-LITERAL

                       call "C$PDF" using HPDF-Page-SetFontAndSize
                           HPDF-Page, page-font, 12

                       call "C$PDF" using HPDF-Page-MeasureText
                           HPDF-Page, WS-LITERAL  temp-width
                           HPDF-False giving text-len

                       MOVE 70  TO TEXT-LEN

                       call "C$PDF" using HPDF-Page-ShowText
                           HPDF-Page, WS-LITERAL, text-len

                       call "C$PDF" using HPDF-Page-MoveTextPos
                             HPDF-Page, 0, -20
                   END-IF

                   call "C$PDF" using HPDF-Page-SetFontAndSize
                         HPDF-Page, page-font, 12

                   call "C$PDF" using HPDF-Page-MeasureText
                         HPDF-Page, II-ITEM (IX) temp-width
                         HPDF-False giving text-len

                   call "C$PDF" using HPDF-Page-ShowText
                         HPDF-Page, II-ITEM (IX) text-len

                   MOVE II-QUANTITY (IX) TO Z-QUANTITY

                   call "C$PDF" using HPDF-Page-MoveTextPos,
                       HPDF-Page, 220, 0

                   call "C$PDF" using HPDF-Page-SetFontAndSize
                       HPDF-Page, page-font, 12

                   call "C$PDF" using HPDF-Page-MeasureText
                       HPDF-Page, Z-QUANTITY temp-width
                       HPDF-False giving text-len

                   call "C$PDF" using HPDF-Page-ShowText
                       HPDF-Page, Z-QUANTITY, text-len


                   MOVE II-RATE (IX) TO Z-RATE

                   call "C$PDF" using HPDF-Page-MoveTextPos,
                       HPDF-Page, 100, 0

                   call "C$PDF" using HPDF-Page-SetFontAndSize,
                       HPDF-Page, page-font, 12

                   call "C$PDF" using HPDF-Page-MeasureText
                       HPDF-Page, Z-RATE  temp-width
                       HPDF-False giving text-len

                   call "C$PDF" using HPDF-Page-ShowText
                       HPDF-Page, Z-RATE text-len

                   COMPUTE Z-AMOUNT = II-RATE (IX) * II-QUANTITY (IX)

                   call "C$PDF" using HPDF-Page-MoveTextPos,
                       HPDF-Page, 80, 0

                   call "C$PDF" using HPDF-Page-SetFontAndSize,
                       HPDF-Page, page-font, 12

                   call "C$PDF" using HPDF-Page-MeasureText,
                       HPDF-Page, Z-AMOUNT  temp-width,
                       HPDF-False giving text-len

                   call "C$PDF" using HPDF-Page-ShowText,
                       HPDF-Page, Z-AMOUNT text-len

           END-PERFORM.

           CALL "C$PDF" USING HPDF-PAGE-ENDTEXT, HPDF-PAGE.

       PAGE-SETUP.
      *==========
           CALL "C$PDF" USING HPDF-SETCompressionMode,
               HPDF-Doc, HPDF-COMP-ALL.

      * Get a FONT handle, and SET a SIZE
           CALL "C$PDF" USING HPDF-GETFONT
                HPDF-DOC, "Helvetica"
                GIVING PAGE-FONT

           CALL "C$PDF" USING HPDF-AddPAGE, HPDF-Doc
               GIVING HPDF-PAGE
           if HPDF-PAGE = null
               CALL "C$PDF" USING HPDF-Free, HPDF-Doc
               display message "Unable to create PDF PAGE"
               stop run
           end-if

           CALL "C$PDF" USING HPDF-SETVIEWERPREFERENCE
                HPDF-DOC,
                HPDF-PRINT-SCALING-NONE

      * SET the PAGE SIZE to letter and direction to portrait
           CALL "C$PDF" USING HPDF-PAGE-SETSIZE
                HPDF-PAGE, HPDF-PAGE-SIZE-LETTER,
                HPDF-PAGE-PORTRAIT
           .

       OUTLINE-AND-TITLE.
      *=================
      * Get the PAGE HEIGHT
           CALL "C$PDF" USING HPDF-PAGE-GETHEIGHT
              HPDF-PAGE, GIVING HPDF-PAGEHEIGHT-R

      * Get the PAGE WIDTH
           CALL "C$PDF" USING HPDF-PAGE-GETWIDTH
              HPDF-PAGE, GIVING HPDF-PAGEWIDTH-R

           CALL "C$PDF" USING HPDF-PAGE-SETLineWIDTH,
               HPDF-PAGE, 1

           SUBTRACT 100 FROM HPDF-PAGEWIDTH
                        GIVING HPDF-RECTANGLE-WIDTH

           SUBTRACT 110 FROM HPDF-PAGEHEIGHT
                        GIVING HPDF-RECTANGLE-HEIGHT


           CALL "C$PDF" USING HPDF-PAGE-RECTANGLE, HPDF-PAGE,
               50, 75,
               HPDF-RECTANGLE-WIDTH, HPDF-RECTANGLE-HEIGHT.

           CALL "C$PDF" USING HPDF-PAGE-Stroke, HPDF-PAGE

           CALL "C$PDF" USING HPDF-PAGE-SETFONTAndSIZE,
               HPDF-PAGE, PAGE-FONT, 24

           CALL "C$PDF" USING HPDF-PAGE-TextWIDTH, HPDF_PAGE,
               PAGE-title GIVING HPDF-TextWIDTH-R

           COMPUTE TEMP-WIDTH = (HPDF-PAGEWIDTH - HPDF-textWIDTH)/ 2
           COMPUTE TEMP-HEIGHT = HPDF-PAGEHEIGHT - 50

           CALL "C$PDF" USING HPDF-PAGE-BeginText, HPDF-PAGE

           CALL "C$PDF" USING HPDF-PAGE-TextOut, HPDF-PAGE,
               TEMP-WIDTH, TEMP-HEIGHT, PAGE-title

           CALL "C$PDF" USING HPDF-PAGE-EndText, HPDF-PAGE.

           MOVE SPACES TO JPG-NAME.
           STRING THE-DESKTOP DELIMITED BY LOW-VALUES
                 "logo.jpg"   DELIMITED BY SIZE
             INTO JPG-NAME.

           move 0 to X
           subtract 410 from my-page-height giving Y
           move "24bit color image" to page-description
           perform draw-image.

       draw-image.
           call "C$PDF" using HPDF-LoadJpegImageFromFile,
                HPDF-Doc, full-name giving HPDF-Image

           call "C$PDF" using HPDF-Image-GetWidth, HPDF-Image
                giving ImageWidth

           call "C$PDF" using HPDF-Image-GetHeight, HPDF-Image
                giving ImageHeight

           call "C$PDF" using HPDF-Page-DrawImage, HPDF-Page,
                HPDF-Image, 60, 640, 200 113


           call "C$PDF" using HPDF-Page-BeginText, HPDF-Page

           call "C$PDF" using HPDF-Page-MoveTextPos,
                              HPDF-Page, 0 0

           call "C$PDF" using HPDF-Page-EndText, HPDF-Page.

       Z000-INITIALIZATION.
      *===================
           PERFORM Z100-DATE-INITIALIZATION.

           ACCEPT WORK-FIELD FROM ENVIRONMENT "TERM".
           IF  WORK-FIELD NOT = SPACES
               MOVE 1 TO OS-TYPE
               MOVE "Unix" TO THE-OS
               ACCEPT THE-HOST FROM ENVIRONMENT "HOSTNAME"
           ELSE
               MOVE 0 TO OS-TYPE
               MOVE "Windows" TO THE-OS
               ACCEPT THE-HOST FROM ENVIRONMENT "COMPUTERNAME"
           END-IF.

           ACCEPT THE-FS FROM ENVIRONMENT "DEFAULT_HOST".

           MOVE SPACES TO THE-DESKTOP.
           ACCEPT WORK-FIELD FROM ENVIRONMENT "USERPROFILE".
           INSPECT WORK-FIELD REPLACING TRAILING SPACES BY LOW-VALUES.
           STRING WORK-FIELD DELIMITED BY LOW-VALUES
                 "\Desktop\"  DELIMITED BY SIZE
             INTO THE-DESKTOP.
           INSPECT THE-DESKTOP REPLACING TRAILING SPACES BY LOW-VALUES.

           MOVE SPACES TO UX-TEXT-FILE.
           STRING THE-DESKTOP DELIMITED BY LOW-VALUES
                 "Invoice.txt" DELIMITED BY SIZE
             INTO UX-TEXT-FILE.

           PERFORM Z200-LOAD-INVOICE.

           MOVE SPACES TO PDF-FILENAME.
           STRING THE-DESKTOP DELIMITED BY LOW-VALUES
                 WS-INVOICE   DELIMITED BY SPACES
                 ".pdf" DELIMITED BY SIZE
             INTO PDF-FILENAME.

       Z100-DATE-INITIALIZATION.
      *========================
           ACCEPT SYSTEM-DATE FROM CENTURY-DATE.
           ACCEPT SYSTEM-TIME FROM TIME.

           COMPUTE N-DATE = 10000.0001 * SYSTEM-DATE.
           MOVE N-DATE TO REPORT-DATE.
           MOVE SYSTEM-TIME TO REPORT-TIME.
           INSPECT REPORT-TIME REPLACING ALL "/" BY ":".

       Z200-LOAD-INVOICE.
      *=================
           OPEN INPUT TEXT-FILE.
           PERFORM NEXT-TEXT-RECORD.

           MOVE SPACES TO ITEM-ARRAY.
           INITIALIZE ITEM-ARRAY.

           PERFORM UNTIL TEXT-FILE-STATUS NOT = ZEROES
                   PERFORM Z300-PROCESS-ONE-REC
                   PERFORM NEXT-TEXT-RECORD
           END-PERFORM.
           CLOSE TEXT-FILE.
           MOVE II-TOTAL-AMOUNT TO WS-BALANCE-DUE.

       Z300-PROCESS-ONE-REC.
      *====================
           EVALUATE INVOICE-KEYWORD
               WHEN "INVOICE"
                    MOVE INVOICE-VALUE TO WS-INVOICE
               WHEN "DATE"
                    MOVE INVOICE-VALUE TO DATE9 WITH CONVERT
                    COMPUTE WS-INVOICE-DATE = DATE9 * 10000.0001
               WHEN "DUE"
                    MOVE INVOICE-VALUE TO DATE9 WITH CONVERT
                    COMPUTE WS-DUE-DATE = DATE9 * 10000.0001
               WHEN "COMPANY"
                    MOVE INVOICE-VALUE TO WS-BILL-COMPANY
               WHEN "ADDRESS"
                    MOVE INVOICE-VALUE TO WS-BILL-ADDRESS
               WHEN "CSZ"
                    MOVE INVOICE-VALUE TO WS-BILL-CSZ
               WHEN "I"
                    PERFORM Z400-PROCESS-ITEM
                    MOVE INVOICE-VALUE TO WS-BALANCE-DUE
           END-EVALUATE.

       Z400-PROCESS-ITEM.
      *=================
           MOVE 1 TO IX.

           UNSTRING TEXT-RECORD DELIMITED BY X"09"
               INTO INVOICE-VALUE WITH POINTER IX.

           UNSTRING TEXT-RECORD DELIMITED BY X"09"
               INTO INVOICE-VALUE WITH POINTER IX.

           IF  II-X = 99
               EXIT PARAGRAPH
           END-IF.
           ADD 1 TO II-X.


           MOVE INVOICE-VALUE TO II-ITEM (II-X).

           UNSTRING TEXT-RECORD DELIMITED BY X"09"
               INTO INVOICE-VALUE WITH POINTER IX.
           MOVE INVOICE-VALUE TO II-QUANTITY (II-X) WITH CONVERT.

           UNSTRING TEXT-RECORD DELIMITED BY X"09"
               INTO INVOICE-VALUE WITH POINTER IX.
           MOVE INVOICE-VALUE TO II-RATE (II-X) WITH CONVERT.

           COMPUTE II-TOTAL-AMOUNT = II-TOTAL-AMOUNT +
                  ( II-QUANTITY (II-X) * II-RATE (II-X) )

       NEXT-TEXT-RECORD.
      *================
           MOVE SPACES TO TEXT-RECORD.
           MOVE SPACES TO INVOICE-RECORD.

           READ TEXT-FILE NEXT RECORD
             AT END
               MOVE SPACES TO TEXT-RECORD
             NOT AT END
               MOVE SPACES TO INVOICE-RECORD
               UNSTRING TEXT-RECORD DELIMITED BY X"09"
                   INTO INVOICE-KEYWORD INVOICE-VALUE
           END-READ.

       Z900-TERMINATION.
      *================
      * Save the final file and exit
           CALL "C$PDF" USING HPDF-SAVETOFILE, HPDF-DOC,
               PDF-FILENAME.

           CALL "C$PDF" USING HPDF-FREE, HPDF-DOC.

